/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.zombie_dungeon;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsapi.world.structure.processor.ISafeWorldModifier;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3749;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class ZombieMainStairsProcessor
extends class_3491
implements ISafeWorldModifier {
    public static final ZombieMainStairsProcessor INSTANCE = new ZombieMainStairsProcessor();
    public static final MapCodec<ZombieMainStairsProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    private static final BlockStateRandomizer STAIR_SELECTOR = new BlockStateRandomizer(class_2246.field_10596.method_9564()).addBlock(class_2246.field_10207.method_9564(), 0.4f).addBlock(class_2246.field_10351.method_9564(), 0.1f).addBlock(class_2246.field_10405.method_9564(), 0.1f).addBlock(class_2246.field_10543.method_9564(), 0.1f).addBlock(class_2246.field_10445.method_9564(), 0.1f).addBlock(class_2246.field_9989.method_9564(), 0.1f);
    private static final BlockStateRandomizer COBBLE_SELECTOR = new BlockStateRandomizer(class_2246.field_10445.method_9564()).addBlock(class_2246.field_9989.method_9564(), 0.3f);

    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 structurePlacementData) {
        if (blockInfoGlobal.comp_1342().method_26204() == class_2246.field_22099) {
            class_2680 lanternBlock;
            int middleSurfaceHeight;
            class_2338.class_2339 temp = blockInfoGlobal.comp_1341().method_25503();
            class_2350 facing = structurePlacementData.method_15113().method_10503((class_2350)blockInfoGlobal.comp_1342().method_11654((class_2769)class_2510.field_11571));
            class_2470 rotation = structurePlacementData.method_15113().method_10501(class_2470.field_11464);
            int maxLength = BetterDungeonsCommon.CONFIG.zombieDungeons.zombieDungeonMaxSurfaceStaircaseLength;
            class_2338 maxSurfacePos = blockInfoGlobal.comp_1341().method_10079(facing, maxLength).method_10079(class_2350.field_11036, maxLength);
            temp.method_10104(facing, maxLength);
            int surfaceHeight = levelReader.method_8624(class_2902.class_2903.field_13194, temp.method_10263(), temp.method_10260());
            if (surfaceHeight >= maxSurfacePos.method_10264() || surfaceHeight <= blockInfoGlobal.comp_1341().method_10264()) {
                blockInfoGlobal = new class_3499.class_3501(blockInfoGlobal.comp_1341(), class_2246.field_10543.method_9564(), null);
                return blockInfoGlobal;
            }
            class_5819 random = structurePlacementData.method_15115(blockInfoGlobal.comp_1341());
            class_2338.class_2339 leftPos = new class_2338((class_2382)blockInfoGlobal.comp_1341().method_10093(facing.method_10160())).method_25503();
            class_2338.class_2339 middlePos = new class_2338((class_2382)blockInfoGlobal.comp_1341()).method_25503();
            class_2338.class_2339 rightPos = new class_2338((class_2382)blockInfoGlobal.comp_1341().method_10093(facing.method_10170())).method_25503();
            for (int i = 0; i < maxLength && (middleSurfaceHeight = levelReader.method_8624(class_2902.class_2903.field_13194, middlePos.method_10263(), middlePos.method_10260())) >= middlePos.method_10264(); ++i) {
                int y;
                class_2680 tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (class_2338)leftPos)) {
                    if (this.isMaterialLiquidSafe(levelReader, leftPos.method_10093(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10445.method_9564(), (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (class_2338)middlePos)) {
                    if (this.isMaterialLiquidSafe(levelReader, middlePos.method_10093(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10445.method_9564(), (class_2338)middlePos, structurePlacementData.method_15114(), rotation);
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (class_2338)middlePos, structurePlacementData.method_15114(), rotation);
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (class_2338)rightPos)) {
                    if (this.isMaterialLiquidSafe(levelReader, rightPos.method_10093(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10445.method_9564(), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
                    }
                }
                for (int y2 = middlePos.method_10264() + 1; y2 <= middlePos.method_10264() + 3; ++y2) {
                    temp.method_10103(leftPos.method_10263(), y2, leftPos.method_10260());
                    this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10543.method_9564(), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                    temp.method_10103(middlePos.method_10263(), y2, middlePos.method_10260());
                    this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10543.method_9564(), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                    temp.method_10103(rightPos.method_10263(), y2, rightPos.method_10260());
                    this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10543.method_9564(), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                }
                float cobbleChance = (float)(maxLength - i) / (float)maxLength;
                cobbleChance = Math.max(cobbleChance, 0.25f);
                temp.method_10103(leftPos.method_10263(), leftPos.method_10264() + 4, leftPos.method_10260());
                Optional tempOptional = this.getBlockStateSafe(levelReader, (class_2338)temp);
                if (tempOptional.isEmpty() || ((class_2680)tempOptional.get()).method_51176() || random.method_43057() < cobbleChance && ((class_2680)tempOptional.get()).method_51367()) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                }
                temp.method_10103(middlePos.method_10263(), middlePos.method_10264() + 4, middlePos.method_10260());
                tempOptional = this.getBlockStateSafe(levelReader, (class_2338)temp);
                if (tempOptional.isEmpty() || ((class_2680)tempOptional.get()).method_51176() || random.method_43057() < cobbleChance && ((class_2680)tempOptional.get()).method_51367()) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                }
                temp.method_10103(rightPos.method_10263(), rightPos.method_10264() + 4, rightPos.method_10260());
                tempOptional = this.getBlockStateSafe(levelReader, (class_2338)temp);
                if (tempOptional.isEmpty() || ((class_2680)tempOptional.get()).method_51176() || random.method_43057() < cobbleChance && ((class_2680)tempOptional.get()).method_51367()) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                }
                temp.method_10101((class_2382)leftPos.method_10093(facing.method_10160()));
                for (y = 0; y <= 4; ++y) {
                    tempOptional = this.getBlockStateSafe(levelReader, (class_2338)temp);
                    if (tempOptional.isEmpty() || ((class_2680)tempOptional.get()).method_51176() || random.method_43057() < cobbleChance && ((class_2680)tempOptional.get()).method_51367()) {
                        this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                    }
                    temp.method_10098(class_2350.field_11036);
                }
                temp.method_10101((class_2382)rightPos.method_10093(facing.method_10170()));
                for (y = 0; y <= 4; ++y) {
                    tempOptional = this.getBlockStateSafe(levelReader, (class_2338)temp);
                    if (tempOptional.isEmpty() || ((class_2680)tempOptional.get()).method_51176() || random.method_43057() < cobbleChance && ((class_2680)tempOptional.get()).method_51367()) {
                        this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (class_2338)temp, structurePlacementData.method_15114(), rotation);
                    }
                    temp.method_10098(class_2350.field_11036);
                }
                leftPos.method_10098(facing).method_10098(class_2350.field_11036);
                middlePos.method_10098(facing).method_10098(class_2350.field_11036);
                rightPos.method_10098(facing).method_10098(class_2350.field_11036);
            }
            leftPos.method_10098(facing.method_10153()).method_10098(class_2350.field_11033);
            middlePos.method_10098(facing.method_10153()).method_10098(class_2350.field_11033);
            rightPos.method_10098(facing.method_10153()).method_10098(class_2350.field_11033);
            BlockStateRandomizer tombSelector = new BlockStateRandomizer(class_2246.field_10445.method_9564()).addBlock(class_2246.field_9989.method_9564(), 0.4f);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10136.method_9564(), leftPos.method_10079(class_2350.field_11036, 2), structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10136.method_9564(), middlePos.method_10079(class_2350.field_11036, 2), structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10136.method_9564(), rightPos.method_10079(class_2350.field_11036, 2), structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10360.method_9564(), leftPos.method_10079(class_2350.field_11036, 3), structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10360.method_9564(), middlePos.method_10079(class_2350.field_11036, 3), structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10360.method_9564(), rightPos.method_10079(class_2350.field_11036, 3), structurePlacementData.method_15114(), rotation);
            class_2680 class_26802 = lanternBlock = BetterDungeonsCommon.CONFIG.general.enableNetherBlocks ? (class_2680)class_2246.field_22110.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true)) : (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true));
            if (random.method_43057() < 0.25f) {
                this.setBlockStateSafeWithPlacement(levelReader, lanternBlock, leftPos.method_10079(class_2350.field_11036, 1), structurePlacementData.method_15114(), rotation);
            } else if (random.method_43057() < 0.25f) {
                this.setBlockStateSafeWithPlacement(levelReader, lanternBlock, rightPos.method_10079(class_2350.field_11036, 1), structurePlacementData.method_15114(), rotation);
            }
            leftPos.method_10098(facing.method_10160());
            rightPos.method_10098(facing.method_10170());
            this.setColumn(levelReader, tombSelector, leftPos.method_10093(class_2350.field_11033), random);
            this.setColumn(levelReader, tombSelector, rightPos.method_10093(class_2350.field_11033), random);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10093.method_9564(), (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10093.method_9564(), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10093.method_9564(), (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10093.method_9564(), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10360.method_9564(), (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, class_2246.field_10360.method_9564(), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateRandom(levelReader, class_2246.field_10360.method_9564(), (class_2338)leftPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            this.setBlockStateRandom(levelReader, class_2246.field_10360.method_9564(), (class_2338)rightPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            leftPos.method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(facing.method_10153());
            rightPos.method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(facing.method_10153());
            this.setColumn(levelReader, tombSelector, leftPos.method_10093(class_2350.field_11033), random);
            this.setColumn(levelReader, tombSelector, rightPos.method_10093(class_2350.field_11033), random);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (class_2338)leftPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            leftPos.method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(facing.method_10153());
            rightPos.method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(facing.method_10153());
            this.setColumn(levelReader, tombSelector, leftPos.method_10093(class_2350.field_11033), random);
            this.setColumn(levelReader, tombSelector, rightPos.method_10093(class_2350.field_11033), random);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)leftPos, structurePlacementData.method_15114(), rotation);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (class_2338)leftPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            leftPos.method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(facing.method_10153());
            rightPos.method_10098(class_2350.field_11033).method_10098(class_2350.field_11033).method_10098(facing.method_10153());
            this.setColumn(levelReader, tombSelector, leftPos.method_10093(class_2350.field_11033), random);
            this.setColumn(levelReader, tombSelector, rightPos.method_10093(class_2350.field_11033), random);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (class_2338)leftPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation);
            leftPos.method_10098(class_2350.field_11036);
            rightPos.method_10098(class_2350.field_11036);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (class_2338)rightPos, structurePlacementData.method_15114(), rotation, random, 0.5f);
            blockInfoGlobal = new class_3499.class_3501(blockInfoGlobal.comp_1341(), STAIR_SELECTOR.get(random), blockInfoGlobal.comp_1343());
        }
        return blockInfoGlobal;
    }

    protected class_3828<?> method_16772() {
        return StructureProcessorTypeModule.ZOMBIE_MAIN_STAIRS_PROCESSOR;
    }

    private void setBlockStateSafeWithPlacement(class_4538 levelReader, class_2680 blockState, class_2338 pos, class_2415 mirror, class_2470 rotation) {
        if (mirror != class_2415.field_11302) {
            blockState = blockState.method_26185(mirror);
        }
        if (rotation != class_2470.field_11467) {
            blockState = blockState.method_26186(rotation);
        }
        this.setBlockStateSafe(levelReader, pos, blockState);
    }

    private void setBlockStateRandom(class_4538 levelReader, class_2680 blockState, class_2338 pos, class_2415 mirror, class_2470 rotation, class_5819 random, float chance) {
        if (random.method_43057() < chance) {
            this.setBlockStateSafeWithPlacement(levelReader, blockState, pos, mirror, rotation);
        }
    }

    private void setColumn(class_4538 levelReader, BlockStateRandomizer selector, class_2338 pos, class_5819 random) {
        class_2338.class_2339 mutable = pos.method_25503();
        Optional currBlock = this.getBlockStateSafe(levelReader, (class_2338)mutable);
        while (mutable.method_10264() > levelReader.method_31607() && (currBlock.isEmpty() || ((class_2680)currBlock.get()).method_26215() || ((class_2680)currBlock.get()).method_51176())) {
            this.setBlockStateSafe(levelReader, (class_2338)mutable, selector.get(random));
            mutable.method_10098(class_2350.field_11033);
            currBlock = this.getBlockStateSafe(levelReader, (class_2338)mutable);
        }
    }
}

